﻿using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq; 
using System.Text;
using System.Windows.Forms;
using System.Numerics;
using System.Globalization;
using System.Security;
using System.Security.Cryptography;
using System.Security.Cryptography.X509Certificates;

namespace CryptoMapi_Test
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }


        const string szOID_CP_GOST_R3410EL = "1.2.643.2.2.19";         //  Алгоритм ГОСТ Р 34.10 - 2001, используемый при экспорте / импорте ключей
        const string szOID_CP_GOST_R3410_12_256 = "1.2.643.7.1.1.1.1"; //  Алгоритм ГОСТ Р 34.10 - 2012 для ключей длины 256 бит, используемый при экспорте / импорте ключей
        const string szOID_CP_GOST_R3410_12_512 = "1.2.643.7.1.1.1.2"; //  Алгоритм ГОСТ Р 34.10 - 2012 для ключей длины 512 бит, используемый при экспорте / импорте ключей


        private void Form1_Load(object sender, EventArgs e)
        {
            string DirTests = Application.StartupPath.ToString();
            FileData.Text = DirTests + "\\FileData.bin";
            SourceFileData.Text = FileData.Text;
            FileCertificate.Text = DirTests + "\\2001.cer";
            FileSignedData.Text = DirTests + "\\php2001.sgn";
        } 

        private void button1_Click(object sender, EventArgs e)
        {
             
        }

        private void button2_Click(object sender, EventArgs e)
        {
             
        }

        private void button3_Click(object sender, EventArgs e)
        {
            

            X509Certificate2 Certificate = new X509Certificate2();
            try
            {
                Certificate.Import(FileCertificate.Text);
            }
            catch (System.Exception E)
            {
                throw new System.Exception("Ошибка при чтении сертификата: " + E.Message);
            }

            byte[] Data = System.IO.File.ReadAllBytes(FileData.Text);
            byte[] HashValue = null;  //     CryptoMAPI.Lib.GetDigest(Data); - вычисляет для старого алгоритма хеширования

            if (Certificate.PublicKey.Oid.Value.ToString() == szOID_CP_GOST_R3410EL)
            {
                HashValue = CryptoMAPI.Lib.GetDigest3411(Data);
                MessageBox.Show("Будет использован алгоритм хеширования: GOST_R3411");
            }

            if (Certificate.PublicKey.Oid.Value.ToString() == szOID_CP_GOST_R3410_12_256)
            {
                HashValue =  CryptoMAPI.Lib.GetDigest2012_256(Data); 
                MessageBox.Show("Будет использован алгоритм хеширования: GOST_R3411 2012_256");
            }

            if (Certificate.PublicKey.Oid.Value.ToString() == szOID_CP_GOST_R3410_12_512)
            {
                HashValue = CryptoMAPI.Lib.GetDigest2012_512(Data); 
                MessageBox.Show("Будет использован алгоритм хеширования: GOST_R3411 2012_512");
            }
             
            if (HashValue==null)
            {
                MessageBox.Show("Алгоритм хеширования не определен");
                return;
            }

            byte[] SignedValue = System.IO.File.ReadAllBytes(FileSignedData.Text);

            if (ReverseArrayChk.Checked)
            {
                SignedValue = SignedValue.Reverse().ToArray(); 
            } 

            bool ret = false; 
            try
            { // при проверке - передаем рассчитанный хеш от данных и значение подписи
                ret = CryptoMAPI.Lib.VerifySignature(HashValue, SignedValue, FileCertificate.Text);
            }
            catch (Exception E)
            {
                MessageBox.Show("При проверке подписи произошла ошибка: "+E.Message);
                return;
            } 
            if (ret)
            {
                MessageBox.Show("Подпись успешно проверена");
            }
            else
            {
                MessageBox.Show("Ошибка - подпись неверна");
            }
        }
         

        private void button4_Click(object sender, EventArgs e)
        {
            if (!File.Exists(FileData.Text))
            {
                MessageBox.Show("Не найден указанный файл: \n"+ FileData.Text);
                return;
            } 
            byte[] Data = System.IO.File.ReadAllBytes(FileData.Text);
            // вычисление хеша
            byte[] HashValue = null;

            if (rb1994.Checked)
            {
                HashValue = CryptoMAPI.Lib.GetDigest(Data);
            }

            if (rb2012_256.Checked)
            {
                HashValue = CryptoMAPI.Lib.GetDigest2012_256(Data);
            }

            if (rb2012_512.Checked)
            {
                HashValue = CryptoMAPI.Lib.GetDigest2012_512(Data);
            }

            if (HashValue == null)
            {
                MessageBox.Show("Хеш не был рассчитан");
                return;
            }
            // вывод в hex
            DataHash.Text = BitConverter.ToString(HashValue).Replace("-", "");
            // вывод в base64
            HashAsBASE64.Text = Convert.ToBase64String(HashValue);

            // преобразование серийного номера сертификата для поиска
            BigInteger FindSerial = BigInteger.Parse(SerialNumber.Text);
            byte[] SignedHashValue = null;
            // Подписываем хеш
            //for (int i = 0; i < 1000; i++)
            // {
           // old SignedHashValue = CryptoMAPI.Lib.GetSignature(Data, FindSerial, ContainerPassword.Text);
           // new - входящий параметр должен быть ранее расчитанный хеш:
            SignedHashValue = CryptoMAPI.Lib.GetSignature(HashValue, FindSerial, ContainerPassword.Text);
            // }

             

            // сохранение в файл
            File.WriteAllBytes(FileData.Text+".hash", HashValue);
            File.WriteAllBytes(FileSignedData.Text, SignedHashValue);

            SignDataAsHEX.Text = BitConverter.ToString(SignedHashValue).Replace("-", "");
            SignDataAsBase64.Text = Convert.ToBase64String(SignedHashValue);

            MessageBox.Show("Выполнено!");
        }
         
        private void button5_Click(object sender, EventArgs e)
        {
            // для тестов можно инициализировать вручную или введенные из списка
            Dictionary<string, string> Data = new Dictionary<string, string> { };
            /*
            {
             {"TerminalKey", "1493886960268"},
             {"CustomerKey", "1"} 
            }; 
            MessageBox.Show(GetDictionaryValues(Data)); 
           */
            if (DictKeys.Lines.Count()!= DictValues.Lines.Count())
            {
                MessageBox.Show("В списках должно быть одинаковое количество ключей и значений");
                return;
            }

            for (int i = 0; i < DictKeys.Lines.Count(); i++)
            {
                Data.Add(DictKeys.Lines[i], DictValues.Lines[i]);
            }
            MessageBox.Show(  "Данные, которые будут обработаны:\n"+CryptoMAPI.Lib.GetDictionaryValues(Data));
        }

        private void button6_Click(object sender, EventArgs e)
        {
            if (!File.Exists(FileData.Text))
            {
                MessageBox.Show("Не найден указанный файл: \n" + FileData.Text);
                return;
            }
            // чтение файла
            byte[] Data = System.IO.File.ReadAllBytes(FileData.Text);
            // вычисление хеша
            byte[] HashValue = null;

            if (rb1994.Checked)
            {
                HashValue = CryptoMAPI.Lib.GetDigest(Data);
                File.WriteAllBytes(FileData.Text + "1994.hash", HashValue);
            }

            if (rb2012_256.Checked)
            {
                HashValue = CryptoMAPI.Lib.GetDigest2012_256(Data);
                File.WriteAllBytes(FileData.Text + "256.hash", HashValue);
            }

            if (rb2012_512.Checked)
            {
                HashValue = CryptoMAPI.Lib.GetDigest2012_512(Data);
                File.WriteAllBytes(FileData.Text + "512.hash", HashValue);
            }

            if (HashValue == null)
            {
                MessageBox.Show("Хеш не был рассчитан");
                return;
            }



            // вывод в HEX
            DataHash.Text = BitConverter.ToString(HashValue).Replace("-", "");
            // вывод в base64
            HashAsBASE64.Text = Convert.ToBase64String(HashValue);


        }

        private void button1_Click_1(object sender, EventArgs e)
        {
            // для тестов можно инициализировать вручную или введенные из списка
            Dictionary<string, string> DataDict = new Dictionary<string, string> { };
            /*
            {
             {"TerminalKey", "1493886960268"},
             {"CustomerKey", "1"} 
            }; 
            MessageBox.Show(GetDictionaryValues(Data)); 
           */
            if (DictKeys.Lines.Count() != DictValues.Lines.Count())
            {
                MessageBox.Show("В списках должно быть одинаковое количество ключей и значений");
                return;
            } 
            for (int i = 0; i < DictKeys.Lines.Count(); i++)
            {
                DataDict.Add(DictKeys.Lines[i], DictValues.Lines[i]);
            }
           MessageBox.Show("Данные, которые будут обработаны:\n" + CryptoMAPI.Lib.GetDictionaryValues(DataDict));
             
            byte[] Data = Encoding.ASCII.GetBytes(CryptoMAPI.Lib.GetDictionaryValues(DataDict));
            // вычисление хеша
            byte[] HashValue = null;

            if (rb1994.Checked)
            {
                HashValue = CryptoMAPI.Lib.GetDigest(Data);
            }

            if (rb2012_256.Checked)
            {
                HashValue = CryptoMAPI.Lib.GetDigest2012_256(Data);
            }

            if (rb2012_512.Checked)
            {
                HashValue = CryptoMAPI.Lib.GetDigest2012_512(Data);
            }
            // вывод в HEX
            DataHash.Text = BitConverter.ToString(HashValue).Replace("-", "");
            // вывод в base64
            HashAsBASE64.Text = Convert.ToBase64String(HashValue);
        }

        private void button2_Click_1(object sender, EventArgs e)
        {
            // для тестов можно инициализировать вручную или введенные из списка
            Dictionary<string, string> DataDict = new Dictionary<string, string> { };
            /*
            {
             {"TerminalKey", "1493886960268"},
             {"CustomerKey", "1"} 
            }; 
            MessageBox.Show(GetDictionaryValues(Data)); 
           */
            if (DictKeys.Lines.Count() != DictValues.Lines.Count())
            {
                MessageBox.Show("В списках должно быть одинаковое количество ключей и значений");
                return;
            }
            for (int i = 0; i < DictKeys.Lines.Count(); i++)
            {
                DataDict.Add(DictKeys.Lines[i], DictValues.Lines[i]);
            }
            MessageBox.Show("Данные, которые будут обработаны:\n" + CryptoMAPI.Lib.GetDictionaryValues(DataDict));

            byte[] Data = Encoding.ASCII.GetBytes(CryptoMAPI.Lib.GetDictionaryValues(DataDict));
            // вычисление хеша
            byte[] HashValue = null;

            if (rb1994.Checked)
            {
                HashValue = CryptoMAPI.Lib.GetDigest(Data);
            }

            if (rb2012_256.Checked)
            {
                HashValue = CryptoMAPI.Lib.GetDigest2012_256(Data);
            }

            if (rb2012_512.Checked)
            {
                HashValue = CryptoMAPI.Lib.GetDigest2012_512(Data);
            }
            // вывод в HEX
            DataHash.Text = BitConverter.ToString(HashValue).Replace("-", "");
            // вывод в base64
            HashAsBASE64.Text = Convert.ToBase64String(HashValue);
             

            // преобразование серийного номера сертификата для поиска
            BigInteger FindSerial = BigInteger.Parse(SerialNumber.Text);
            // Подписываем хеш  
            // new - входящий параметр должен быть ранее расчитанный хеш:
            byte[] SignedHashValue = CryptoMAPI.Lib.GetSignature(HashValue, FindSerial, ContainerPassword.Text);
            // сохранение в файл
            File.WriteAllBytes(FileSignedData.Text, SignedHashValue); 
            SignDataAsHEX.Text = BitConverter.ToString(SignedHashValue).Replace("-", "");
            SignDataAsBase64.Text = Convert.ToBase64String(SignedHashValue);


            File.WriteAllBytes(FileData.Text + ".hash", HashValue);
            MessageBox.Show("Выполнено!");

        }
    }
}
