<?php

class ControllerExtensionPaymentTBank extends Controller
{
    private $error = array();

    public function install()
    {
        $this->load->model('extension/payment/tbank');
        $this->model_extension_payment_tbank->install();
    }

    public function uninstall()
    {
        $this->load->model('extension/payment/tbank');
        $this->model_extension_payment_tbank->uninstall();
    }

    public function index()
    {
        $data = array();
        $this->load->language('extension/payment/tbank');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('setting/setting');
        $this->load->model('setting/store');
        $this->load->model('extension/payment/tbank');

        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');
        $this->error = array();

        if ($this->request->server['REQUEST_METHOD'] == 'POST') {
            $this->request->post['tbank_enabled_taxation'] = (isset($this->request->post['tbank_enabled_taxation']) && $this->request->post['tbank_enabled_taxation'] = 'on') ? 1 : 0;
        }

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('tbank', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=payment', true));
        } else {
            if (!empty($this->error)) {
                $data['error_warning'] = array_shift($this->error);
            }
        }
        //payment_object
        $data['payment_object'] = $this->language->get('payment_object');
        $data['commodity'] = $this->language->get('commodity');
        $data['excise'] = $this->language->get('excise');
        $data['job'] = $this->language->get('job');
        $data['service'] = $this->language->get('service');
        $data['gambling_bet'] = $this->language->get('gambling_bet');
        $data['gambling_prize'] = $this->language->get('gambling_prize');
        $data['lottery'] = $this->language->get('lottery');
        $data['lottery_prize'] = $this->language->get('lottery_prize');
        $data['intellectual_activity'] = $this->language->get('intellectual_activity');
        $data['payment'] = $this->language->get('payment');
        $data['agent_commission'] = $this->language->get('agent_commission');
        $data['composite'] = $this->language->get('composite');
        $data['another'] = $this->language->get('another');

        //payment_method
        $data['payment_method'] = $this->language->get('payment_method');
        $data['full_prepayment'] = $this->language->get('full_prepayment');
        $data['prepayment'] = $this->language->get('prepayment');
        $data['advance'] = $this->language->get('advance');
        $data['full_payment'] = $this->language->get('taxation');
        $data['partial_payment'] = $this->language->get('partial_payment');
        $data['credit'] = $this->language->get('credit');
        $data['credit_payment'] = $this->language->get('credit_payment');
        $data['heading_title'] = $this->language->get('heading_title');
        $data['terminal_key_label'] = $this->language->get('terminal_key');
        $data['secret_key_label'] = $this->language->get('secret_key');
        $data['currency_label'] = $this->language->get('currency');
        $data['tbank_email_company_label'] = $this->language->get('tbank_email_company');
        $data['payment_url_label'] = $this->language->get('payment_url');
        $data['description_label'] = $this->language->get('description');
        $data['status_label'] = $this->language->get('status');
        $data['status_success_label'] = $this->language->get('status_success');
        $data['status_failed_label'] = $this->language->get('status_failed');
        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');
        $data['status_authorized'] = $this->language->get('status_authorized');
        $data['payment_method'] = $this->language->get('payment_method');
        $data['status_completed'] = $this->language->get('status_completed');
        $data['status_canceled'] = $this->language->get('status_canceled');
        $data['status_rejected'] = $this->language->get('status_rejected');
        $data['status_refunded'] = $this->language->get('status_refunded');
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text'      => $this->language->get('text_home'),
            'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => false
        );
        $data['breadcrumbs'][] = array(
            'text'      => $this->language->get('text_payment'),
            'href'      => $this->url->link('extension/extension', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );
        $data['breadcrumbs'][] = array(
            'text'      => $this->language->get('heading_title'),
            'href'      => $this->url->link('extension/payment/tbank', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );

        //button actions
        $data['action'] = $this->url->link('extension/payment/tbank', 'token=' . $this->session->data['token'], 'SSL');
        $data['cancel'] = $this->url->link('extension/extension', 'token=' . $this->session->data['token'], 'SSL');
        $data['tbank_terminal_key'] = isset($this->request->post['tbank_terminal_key']) ? $this->request->post['tbank_terminal_key'] : $this->config->get('tbank_terminal_key');
        $data['tbank_email_company'] = isset($this->request->post['tbank_email_company']) ? $this->request->post['tbank_email_company'] : $this->config->get('tbank_email_company');
        $data['tbank_secret_key'] = isset($this->request->post['tbank_secret_key']) ? $this->request->post['tbank_secret_key'] : $this->config->get('tbank_secret_key');
        $data['currency'] = isset($this->request->post['currency']) ? $this->request->post['currency'] : $this->config->get('currency');
        $data['description'] = isset($this->request->post['description']) ? $this->request->post['description'] : $this->config->get('description');
        $data['tbank_status'] = isset($this->request->post['tbank_status']) ? $this->request->post['tbank_status'] : $this->config->get('tbank_status');
        $data['order_status_success_id'] = isset($this->request->post['order_status_success_id']) ? $this->request->post['order_status_success_id'] : $this->config->get('order_status_success_id');
        $data['order_status_failed_id'] = isset($this->request->post['order_status_failed_id']) ? $this->request->post['order_status_failed_id'] : $this->config->get('order_status_failed_id');
        $data['tbank_taxation'] = isset($this->request->post['tbank_taxation']) ? $this->request->post['tbank_taxation'] : $this->config->get('tbank_taxation');
        $data['tbank_payment_method'] = isset($this->request->post['tbank_payment_method']) ? $this->request->post['tbank_payment_method'] : $this->config->get('tbank_payment_method');
        $data['tbank_payment_object'] = isset($this->request->post['tbank_payment_object']) ? $this->request->post['tbank_payment_object'] : $this->config->get('tbank_payment_object');
        $data['tbank_order_status_authorized'] = isset($this->request->post['tbank_order_status_authorized']) ? $this->request->post['tbank_order_status_authorized'] : $this->config->get('tbank_order_status_authorized');
        $data['tbank_order_status_completed'] = isset($this->request->post['tbank_order_status_completed']) ? $this->request->post['tbank_order_status_completed'] : $this->config->get('tbank_order_status_completed');
        $data['tbank_order_status_canceled'] = isset($this->request->post['tbank_order_status_canceled']) ? $this->request->post['tbank_order_status_canceled'] : $this->config->get('tbank_order_status_canceled');
        $data['tbank_order_status_rejected'] = isset($this->request->post['tbank_order_status_rejected']) ? $this->request->post['tbank_order_status_rejected'] : $this->config->get('tbank_order_status_rejected');
        $data['tbank_order_status_refunded'] = isset($this->request->post['tbank_order_status_refunded']) ? $this->request->post['tbank_order_status_refunded'] : $this->config->get('tbank_order_status_refunded');
        $data['taxation_label'] = $this->language->get('tbank_taxation');
        $data['tbank_taxations'] = array(
            'osn'                   => $this->language->get('tbank_osn'),
            'usn_income'            => $this->language->get('tbank_usn_income'),
            'usn_income_outcome'    => $this->language->get('tbank_usn_income_outcome'),
            'esn'                   => $this->language->get('tbank_esn'),
            'patent'                => $this->language->get('tbank_patent'),
        );
        $data['payment_method_list'] = array(
            'full_prepayment'       => $this->language->get('full_prepayment'),
            'prepayment'            => $this->language->get('prepayment'),
            'advance'               => $this->language->get('advance'),
            'full_payment'          => $this->language->get('full_payment'),
            'partial_payment'       => $this->language->get('partial_payment'),
            'credit'                => $this->language->get('credit'),
            'credit_payment'        => $this->language->get('credit_payment'),
        );
        $data['payment_object_list'] = array(
            'commodity'             => $this->language->get('commodity'),
            'excise'                => $this->language->get('excise'),
            'job'                   => $this->language->get('job'),
            'service'               => $this->language->get('service'),
            'gambling_bet'          => $this->language->get('gambling_bet'),
            'gambling_prize'        => $this->language->get('gambling_prize'),
            'lottery'               => $this->language->get('lottery'),
            'lottery_prize'         => $this->language->get('lottery_prize'),
            'intellectual_activity' => $this->language->get('intellectual_activity'),
            'payment'               => $this->language->get('payment'),
            'agent_commission'      => $this->language->get('agent_commission'),
            'composite'             => $this->language->get('composite'),
            'another'               => $this->language->get('another'),
        );

        $data['tbank_payment_language'] = isset($this->request->post['tbank_payment_language']) ? $this->request->post['tbank_payment_language'] : $this->config->get('tbank_payment_language');
        $data['payment_language_label'] = $this->language->get('tbank_payment_language');
        $data['tbank_languages'] = array(
            'ru' => $this->language->get('tbank_ru'),
            'en' => $this->language->get('tbank_en'),
        );

        $data['tbank_enabled_taxation_label'] = $this->language->get('tbank_enabled_taxation');
        $data['tbank_enabled_taxation'] = isset($this->request->post['tbank_enabled_taxation']) ? $this->request->post['tbank_enabled_taxation'] : $this->config->get('tbank_enabled_taxation');
        $data['tbank_enabled_ffd12_label'] = $this->language->get('tbank_enabled_ffd12');
        $data['tbank_enabled_ffd12'] = isset($this->request->post['tbank_enabled_ffd12']) ? $this->request->post['tbank_enabled_ffd12'] : $this->config->get('tbank_enabled_ffd12');
        $data['tbank_payment_ffd12_advice'] = $this->language->get('tbank_payment_ffd12_advice');
        $this->load->model('localisation/order_status');
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
        $data['token'] = $this->session->data['token'];

        $this->template = 'extension/payment/tbank.tpl';
        $this->children = array(
            'common/header',
            'common/footer'
        );
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $this->response->setOutput($this->load->view('extension/payment/tbank.tpl', $data));
    }

    protected function validate()
    {
        if (!$this->user->hasPermission('modify', 'extension/payment/tbank')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['tbank_terminal_key'])) {
            $this->error['tbank_terminal_key'] = $this->language->get('error_terminal_key');
        }

        if (empty($this->request->post['tbank_secret_key'])) {
            $this->error['tbank_secret_key'] = $this->language->get('error_secret_key');
        }

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }
}