<?php echo $header; ?>
<?php echo $column_left; ?>

<div id="content">
    <div class="page-header">
        <div class="container-fluid">
            <div class="pull-right">
                <button type="submit" form="form" data-toggle="tooltip" title="<?php echo $button_save; ?>"
                        class="btn btn-primary"><i class="fa fa-save"></i></button>
                <a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>"
                   class="btn btn-default"><i class="fa fa-reply"></i></a>
            </div>

            <h1><?php echo $heading_title; ?></h1>

            <ul class="breadcrumb">
                <?php foreach ($breadcrumbs as $breadcrumb) { ?>
                <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
                <?php } ?>
            </ul>
        </div>
    </div>

    <div class="container-fluid">
        <?php if (isset($error_warning)) { ?>
        <div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
        <?php } ?>

        <div class="panel panel-default">
            <div class="panel-body">
                <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form"
                      class="form-horizontal">

                    <div class="tab-content">
                        <div class="tab-pane active" id="tab-general">
                            <div class="form-group  required">
                                <label class="col-sm-2 control-label"
                                       for="tbank_terminal_key"><?php echo $terminal_key_label; ?></label>

                                <div class="col-sm-10">
                                    <input type="text" name="tbank_terminal_key"
                                           value="<?php echo $tbank_terminal_key; ?>" class="form-control"/>
                                    <?php if (isset($error['terminal_key'])) { ?>
                                    <span class="error"><?php echo $error['terminal_key']; ?></span>
                                    <?php } ?>
                                </div>
                            </div>
                            <div class="form-group  required">
                                <label class="col-sm-2 control-label"
                                       for="tbank_secret_key"><?php echo $secret_key_label; ?></label>

                                <div class="col-sm-10">
                                    <input type="text" name="tbank_secret_key"
                                           value="<?php echo $tbank_secret_key; ?>" class="form-control"/>
                                    <?php if (isset($error['tbank_secret_key'])) { ?>
                                    <span class="error"><?php echo $error['tbank_secret_key']; ?></span>
                                    <?php } ?>
                                </div>
                            </div>

                            <!-- order statuses -->
                            <div class="form-group">
                                <label class="col-sm-2 control-label"
                                       for="tbank_order_status_authorized"><?php echo $status_authorized; ?></label>
                                <div class="col-sm-10">
                                    <select name="tbank_order_status_authorized" id="tbank_order_status_authorized"
                                            class="form-control">
                                        <?php foreach ($order_statuses as $order_status) { ?>
                                        <?php if ($order_status['order_status_id'] == $tbank_order_status_authorized) { ?>
                                        <option value="<?php echo $order_status['order_status_id']; ?>"
                                                selected="selected"><?php echo $order_status['name']; ?></option>
                                        <?php } else { ?>
                                        <option value="<?php echo $order_status['order_status_id']; ?>"><?php echo $order_status['name']; ?></option>
                                        <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>


                            <div class="form-group">
                                <label class="col-sm-2 control-label"
                                       for="tbank_order_status_completed"><?php echo $status_completed; ?></label>

                                <div class="col-sm-10">
                                    <select name="tbank_order_status_completed" id="tbank_order_status_completed"
                                            class="form-control">
                                        <?php foreach ($order_statuses as $order_status) { ?>
                                        <?php if ($order_status['order_status_id'] == $tbank_order_status_completed) { ?>
                                        <option value="<?php echo $order_status['order_status_id']; ?>"
                                                selected="selected"><?php echo $order_status['name']; ?></option>
                                        <?php } else { ?>
                                        <option value="<?php echo $order_status['order_status_id']; ?>"><?php echo $order_status['name']; ?></option>
                                        <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-sm-2 control-label"
                                       for="tbank_order_status_canceled"><?php echo $status_canceled; ?></label>

                                <div class="col-sm-10">
                                    <select name="tbank_order_status_canceled" id="tbank_order_status_canceled"
                                            class="form-control">
                                        <?php foreach ($order_statuses as $order_status) { ?>
                                        <?php if ($order_status['order_status_id'] == $tbank_order_status_canceled) { ?>
                                        <option value="<?php echo $order_status['order_status_id']; ?>"
                                                selected="selected"><?php echo $order_status['name']; ?></option>
                                        <?php } else { ?>
                                        <option value="<?php echo $order_status['order_status_id']; ?>"><?php echo $order_status['name']; ?></option>
                                        <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-sm-2 control-label"
                                       for="tbank_order_status_rejected"><?php echo $status_rejected; ?></label>

                                <div class="col-sm-10">
                                    <select name="tbank_order_status_rejected" id="tbank_order_status_rejected"
                                            class="form-control">
                                        <?php foreach ($order_statuses as $order_status) { ?>
                                        <?php if ($order_status['order_status_id'] == $tbank_order_status_rejected) { ?>
                                        <option value="<?php echo $order_status['order_status_id']; ?>"
                                                selected="selected"><?php echo $order_status['name']; ?></option>
                                        <?php } else { ?>
                                        <option value="<?php echo $order_status['order_status_id']; ?>"><?php echo $order_status['name']; ?></option>
                                        <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-sm-2 control-label"
                                       for="tbank_order_status_refunded"><?php echo $status_refunded; ?></label>

                                <div class="col-sm-10">
                                    <select name="tbank_order_status_refunded" id="tbank_order_status_refunded"
                                            class="form-control">
                                        <?php foreach ($order_statuses as $order_status) { ?>
                                        <?php if ($order_status['order_status_id'] == $tbank_order_status_refunded) { ?>
                                        <option value="<?php echo $order_status['order_status_id']; ?>"
                                                selected="selected"><?php echo $order_status['name']; ?></option>
                                        <?php } else { ?>
                                        <option value="<?php echo $order_status['order_status_id']; ?>"><?php echo $order_status['name']; ?></option>
                                        <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>


                            <div class="form-group">
                                <label class="col-sm-2 control-label"
                                       for="tbank_status"><?php echo $status_label; ?></label>

                                <div class="col-sm-10">
                                    <select name="tbank_status" class="form-control">
                                        <?php if ($tbank_status) { ?>
                                        <option value="1" selected="selected"><?php echo $text_enabled; ?></option>
                                        <option value="0"><?php echo $text_disabled; ?></option>
                                        <?php } else { ?>
                                        <option value="1"><?php echo $text_enabled; ?></option>
                                        <option value="0" selected="selected"><?php echo $text_disabled; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group">
                            <label class="col-sm-2 control-label" for="tbank_enabled_taxation"><?php echo $tbank_enabled_taxation_label; ?></label>
                                <div class="col-sm-10">
                                    <input type="checkbox" name="tbank_enabled_taxation"
                                           onclick="showTBankTaxation(this.checked)"
                                           class="form-control" id="checked" <?php echo ($tbank_enabled_taxation) ? 'checked' : '' ?>
                                    >
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-sm-2 control-label" for="tbank_enabled_ffd12"><?php echo $tbank_enabled_ffd12_label; ?></label>
                                <div class="col-sm-10">
                                    <input type="checkbox" name="tbank_enabled_ffd12"
                                    class="form-control" id="checked"
                                    <?php echo ($tbank_enabled_ffd12) ? 'checked' : '' ?>
                                    >
                                    <p><?php echo $tbank_payment_ffd12_advice?></p>
                                </div>
                            </div>

                            </div>

                            <div class="form-group table-line" id="tbankTaxation">
                                <div class="table-line" id="tbankTaxation">
                                    <label class="col-sm-2 control-label"
                                           for="tbank_taxation"><?php echo $taxation_label; ?></label>
                                    <div class="col-sm-10">
                                        <select name="tbank_taxation" class="form-control">
                                            <?php foreach ($tbank_taxations as $code=>$taxation) { ?>
                                            <option value="<?php echo $code?>"
                                            <?php if ($tbank_taxation == $code) { ?>selected="selected"<?php } ?>
                                            > <?php echo $taxation?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group table-line" id="tbankTaxation">
                                <div class="table-line " id="tbankTaxation">
                                <label class="col-sm-2 control-label"
                                       for="tbank_email_company"><?php echo $tbank_email_company_label; ?></label>

                                <div class="col-sm-10">
                                    <input type="text" name="tbank_email_company"
                                           value="<?php echo $tbank_email_company; ?>" class="form-control"/>
                                    <?php if (isset($error['tbank_email_company'])) { ?>
                                    <span class="error"><?php echo $error['tbank_email_company']; ?></span>
                                    <?php } ?>
                                </div>
                                </div>
                            </div>
                            <div class="form-group table-line" id="tbankTaxation">
                                <div class="table-line " id="tbankTaxation">
                                    <label class="col-sm-2 control-label"
                                           for="tbank_payment_method"><?php echo $payment_method; ?></label>
                                    <div class="col-sm-10">
                                        <select name="tbank_payment_method" id="tbank_payment_method"
                                                class="form-control">
                                            <?php foreach ($payment_method_list as $key => $code) { ?>
                                            <option value="<?php echo $key?>"
                                            <?php if ($tbank_payment_method == $key) { ?>selected="selected"<?php } ?>
                                            > <?php echo $code?> </option><?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group table-line" id="tbankTaxation">
                                <div class="table-line " id="tbankTaxation">
                                    <label class="col-sm-2 control-label"
                                           for="tbank_payment_object"><?php echo $payment_object; ?></label>
                                    <div class="col-sm-10">
                                        <select name="tbank_payment_object" class="form-control">
                                            <?php foreach ($payment_object_list as $key => $code) { ?>
                                            <option value="<?php echo $key?>"
                                            <?php if ($tbank_payment_object == $key) { ?>selected="selected"<?php } ?>
                                            > <?php echo $code?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-sm-2 control-label"
                                       for="tbank_payment_language"><?php echo $payment_language_label; ?></label>
                                <div class="col-sm-10">
                                    <select name="tbank_payment_language" class="form-control">
                                        <?php foreach ($tbank_languages as $code=>$language) { ?>
                                        <option value="<?php echo $code?>"
                                        <?php if ($tbank_payment_language == $code) { ?>selected="selected"<?php } ?>
                                        > <?php echo $language?> </option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>

                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php echo $footer; ?>
<script>
    function showTBankTaxation(checked) {
        var tbankTaxation = document.getElementsByClassName('table-line');
        [].forEach.call(tbankTaxation, function (item) {
            if (checked) {
                item.classList.remove('hidden');
            }
            else {
                item.classList.add('hidden');
            }
        })
    }

    window.onload = function() {
        var checked = document.getElementById('checked').checked;
        this.showTBankTaxation(checked);
    }
</script>
<style>
    .hidden {
        display: none;
    }

</style>